/*
 * AntennaEntry.h
 *
 *  Created on: 16.12.2011
 *      Author: stefan.detter
 */

#ifndef ANTENNAENTRY_H_
#define ANTENNAENTRY_H_

#include "TreeItem.h"

#include <QMap>
#include <QSet>

class ReaderEntry;
class TagEntry;

class AntennaEntry : public TreeItem
{
	Q_OBJECT

public:
	AntennaEntry(ReaderEntry* parent, uint antennaId);
	virtual ~AntennaEntry();

	uint 		antennaId () const;

    void        setActive(bool active);
    void        setReflectedPowerError (bool error, int value );
    void        setReflectedPowerValue ( int value );

public:
	void 		removeRSSI();
	void 		removeReadFrequency();


    int             tagCount() const;
    QSet<QString>   uniqueTagIds() const;
    bool            containsTag ( const QString& tagId ) const;
    TagEntry*       tag ( const QString& tagId ) const;
    TagEntry*       appendTag(const QString& type, const QString& tagId, const QString &visualTagId);
public slots:
    void            removeTag ( const QString& tagId );

    void        inventoryAboutToStart();
    void 		inventoryStarted();
    void 		inventoryStoped();
    void 		inventoryPaused();
    void 		inventoryContinued();

public:
	virtual void		updateDynamicInfo();
	virtual void 		clearTags();

signals:
	void 		updateInformation();

/****************************************************** Display functions */
public:
	virtual TYPE 			itemType() const;
	virtual QVariant 		data(int column, int role) const;
	virtual int 			informationRowCount () const;
	virtual QVariant		information (int row, int column, int role) const;
	virtual QList<int>		informationSpan() const;

private:
    ReaderEntry*				m_reader;
    uint 						m_antennaId;

    bool                        m_active;

	bool						m_receivedRfp;
    double                      m_currentRfp;
    bool                        m_hasRfpError;

	QMap<QString, TagEntry*>	m_tagIndex;

};

#endif /* ANTENNAENTRY_H_ */
